<?php
// router.php — Resuelve un colegio (code/hint) a su URL base y años disponibles
header('Content-Type: application/json; charset=utf-8');

// CORS simple (opcional)
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(204); exit;
}

require_once __DIR__ . '/config.php';

$hint = isset($_GET['hint']) ? strtolower(trim($_GET['hint'])) : '';
if ($hint === '') {
  http_response_code(400);
  echo json_encode(['ok' => false, 'error' => 'Falta parámetro hint']); exit;
}

try {
  $dsn = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset={$DB_CHARSET}";
  $pdo = new PDO($dsn, $DB_USER, $DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

  // 1) Buscar tenant
  $q = $pdo->prepare("SELECT id, code, display_name, base_url, api_base, theme_primary, logo_url, year_active FROM tenants WHERE code = :code AND active = 1 LIMIT 1");
  $q->execute([':code' => $hint]);
  $tenant = $q->fetch(PDO::FETCH_ASSOC);

  if (!$tenant) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Colegió no encontrado']); exit;
  }

  // 2) Listar años disponibles (db_name por año)
  $q2 = $pdo->prepare("SELECT year, db_name FROM tenant_years WHERE tenant_id = :tid ORDER BY year DESC");
  $q2->execute([':tid' => $tenant['id']]);
  $years = $q2->fetchAll(PDO::FETCH_ASSOC);

  echo json_encode([
    'ok' => true,
    'tenant' => [
      'code' => $tenant['code'],
      'name' => $tenant['display_name'],
      'url'  => $tenant['base_url'],
      'api'  => $tenant['api_base'],
      'theme' => [
        'primary' => $tenant['theme_primary'],
        'logo'    => $tenant['logo_url']
      ],
      'year_active' => (int)$tenant['year_active'],
      'years' => $years
    ]
  ]);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['ok' => false, 'error' => 'Error interno']); exit;
}
