-- Crea BD (si no existe). En cPanel también puedes crearla desde el panel.
CREATE DATABASE IF NOT EXISTS `asistoco_core` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `asistoco_core`;

-- Tabla de tenants/colegios
CREATE TABLE IF NOT EXISTS tenants (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(64) NOT NULL UNIQUE,         -- 'demo', 'martin'
  display_name VARCHAR(120) NOT NULL,       -- Nombre legible
  base_url VARCHAR(255) NOT NULL,           -- https://subdominio/app/
  api_base VARCHAR(255) DEFAULT NULL,       -- https://subdominio/api/ (opcional)
  theme_primary VARCHAR(16) DEFAULT '#0f62fe',
  logo_url VARCHAR(255) DEFAULT NULL,
  year_active INT DEFAULT NULL,             -- Año por defecto al entrar (opcional)
  active TINYINT(1) DEFAULT 1
) ENGINE=InnoDB;

-- Años → nombre de BD a usar (por ejemplo, asistoco_martin_2025)
CREATE TABLE IF NOT EXISTS tenant_years (
  id INT AUTO_INCREMENT PRIMARY KEY,
  tenant_id INT NOT NULL,
  year INT NOT NULL,
  db_name VARCHAR(128) NOT NULL,
  UNIQUE KEY uniq_tenant_year (tenant_id, year),
  CONSTRAINT fk_tenant_years_tenant FOREIGN KEY (tenant_id) REFERENCES tenants(id) ON DELETE CASCADE
) ENGINE=InnoDB;

-- Datos iniciales para tus colegios
INSERT INTO tenants (code, display_name, base_url, api_base, theme_primary, logo_url, year_active, active)
VALUES
('demo',   'Colegio Demo',   'https://demo.asisto.com.co/app/',   'https://demo.asisto.com.co/api/',   '#3366ff', NULL, 2019, 1),
('martin', 'Colegio Martín', 'https://martin.asisto.com.co/app/', 'https://martin.asisto.com.co/api/', '#ff9900', NULL, 2025, 1)
ON DUPLICATE KEY UPDATE
  display_name=VALUES(display_name),
  base_url=VALUES(base_url),
  api_base=VALUES(api_base),
  theme_primary=VALUES(theme_primary),
  logo_url=VALUES(logo_url),
  year_active=VALUES(year_active),
  active=VALUES(active);

-- Vincular años para DEMO (una sola base)
INSERT INTO tenant_years (tenant_id, year, db_name)
SELECT t.id, 2019, 'asistoco_demo_2019' FROM tenants t WHERE t.code='demo'
ON DUPLICATE KEY UPDATE db_name=VALUES(db_name);

-- Vincular años para MARTIN (varias bases)
INSERT INTO tenant_years (tenant_id, year, db_name)
SELECT t.id, 2020, 'asistoco_martin_2020' FROM tenants t WHERE t.code='martin'
ON DUPLICATE KEY UPDATE db_name=VALUES(db_name);
INSERT INTO tenant_years (tenant_id, year, db_name)
SELECT t.id, 2021, 'asistoco_martin_2021' FROM tenants t WHERE t.code='martin'
ON DUPLICATE KEY UPDATE db_name=VALUES(db_name);
INSERT INTO tenant_years (tenant_id, year, db_name)
SELECT t.id, 2022, 'asistoco_martin_2022' FROM tenants t WHERE t.code='martin'
ON DUPLICATE KEY UPDATE db_name=VALUES(db_name);
INSERT INTO tenant_years (tenant_id, year, db_name)
SELECT t.id, 2023, 'asistoco_martin_2023' FROM tenants t WHERE t.code='martin'
ON DUPLICATE KEY UPDATE db_name=VALUES(db_name);
INSERT INTO tenant_years (tenant_id, year, db_name)
SELECT t.id, 2024, 'asistoco_martin_2024' FROM tenants t WHERE t.code='martin'
ON DUPLICATE KEY UPDATE db_name=VALUES(db_name);
INSERT INTO tenant_years (tenant_id, year, db_name)
SELECT t.id, 2025, 'asistoco_martin_2025' FROM tenants t WHERE t.code='martin'
ON DUPLICATE KEY UPDATE db_name=VALUES(db_name);
INSERT INTO tenant_years (tenant_id, year, db_name)
SELECT t.id, 2026, 'asistoco_martin_2026' FROM tenants t WHERE t.code='martin'
ON DUPLICATE KEY UPDATE db_name=VALUES(db_name);
